/******************************************************************************
 *
 * PROJECT:  	Virtual Phone (Dyonisus)
 * FILE:     	CFileDB.h
 * AUTHOR:	 	Kevin Alet
 *
 * DESCRIPTION:	
 *				manage Vp storage configuration file
 *
 * REVISION HISTORY:
 * ??/??/??		???		Initial version.
 * 05/04/03		Kal		Make it works only on Windows system
 *
 *****************************************************************************/
/*
 ==============================================================================
 Copyright (c) PalmSource, Inc.
 All rights reserved.
 ==============================================================================
 */

#ifndef		WINDBFILE_H
#define		WINDBFILE_H

#include "VPincs.h"
#include "FileDB.h"

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////

#define kEntryIndexStringLength		8

class CFileText;

class COMMON_API CFileDB 
{
protected:
	CFileText*		mWinTextFile;
public:

	CFileDB(const char *fullNameP);
	~CFileDB();
	virtual Bool	SaveIntegerValue(char *iSectionP, char *iKeyP, UInt32 iValue);
	virtual Bool	SaveStringValue(char *iSectionP, char *iKeyP, char *iValueP);
	virtual Bool	SaveBufferValue(char *iSectionP, char *iKeyP, char *iValueP, UInt16 iValueLen);
	virtual UInt32	GetIntegerValue(char *iSectionP, char *iKeyP, UInt32 iDefaultValue);
	virtual UInt32	GetStringValue(char *iSectionP, char *iKeyP, char *iDefaultValueP, char *iValueP, UInt32 iValueLen);
	virtual UInt32	GetBufferValue(char *iSectionP, char *iKeyP, char *iValueP, UInt16 iValueLen);
	virtual UInt32	GetUnallocatedStringValue(char *iSectionP, char *iKeyP, char *iDefaultValueP, char *&oValueP);
	virtual const char*	GetFileName();


	virtual void IntIndexToDBIndex(UInt16 intIndex, char strIndexP[kEntryIndexStringLength]);
	virtual Bool IsEntryPresent(const char *strIndexP);
	virtual Bool DeleteEntry(const char *strIndexP);
	virtual UInt16 GetEntriesCount();
	virtual UInt16 GetEntriesCountByIndex(UInt16 firstIndex, UInt16 LastIndex);

};


#endif
